SAMPLE=200000
SMPSLUT=445180
SCR=$76000
 ORG 32768
 MOVE.W #25,D7
 LEA SAMPLE,A6
LOAD:
 MOVEM.L D7/A6,-(SP)
 MOVE.W #9,-(SP)
 CLR.W -(SP)
 MOVE.W D7,-(SP)
 MOVE.W #1,-(SP)
 MOVE.W #0,-(SP)
 CLR.L -(SP)
 MOVE.L A6,-(SP)
 MOVE.W #8,-(SP)
 TRAP #14
 ADD.L #20,SP
 MOVEM.L (SP)+,D7/A6
 ADD.L #5120-512,A6
 ADDQ.W #1,D7
 CMP.W #81,D7
 BNE LOAD
 JMP MAIN
BUFFER:
SCBUF: DS.B 5*(32*16)
JETX: DS.B 1000
COLTAB3: DS.B 500
COLTAB4: DS.B 500
MUTB: DS.L 10
MUSC6:
 IBYTES A:THUND.BIN  ;58,158
 ALIGN.W
MUSC1:
 IBYTES ICEM.BIN   ;0,274
MUSC2:
 IBYTES ENDRAM.BIN ;0,278
MUSC3:
 IBYTES WARS.OBJ   ;84,180
 ALIGN.W
MUSC4:
 IBYTES OUTRUN.BIN ;1350,40
 ALIGN.W
MUSC5:        
 IBYTES THRUSTM.OBJ;84,180
 ALIGN.W
MAIN:
 BSR INIT
 BSR MUSIC
INIT:
 MOVE.W #$2700,SR
 LEA SAMPLE,A2
AGAIN2:
 CMP.L #SMPSLUT,A2
 BEQ FINI1
 MOVE.B (A2),D1
 AND.W #$00FF,D1
 ADD.B #$80,D1
 MOVE.B D1,(A2)+
 BRA AGAIN2
FINI1:
 MOVE.W #0,-(SP)
 PEA SCR
 PEA SCR
 MOVE.W #5,-(SP)
 TRAP #14
 ADD.L #12,SP
 MOVE.W #6,-(SP)
 MOVE.W #26,-(SP)
 TRAP #14
 ADDQ.L #4,SP
 PEA STR1
 MOVE.W #1,-(SP)
 MOVE.W #25,-(SP)
 TRAP #14
 ADDQ.L #8,SP
 MOVE.L #$31415926,$426
 MOVE.L #RESETR,$42A
 LEA $FF8240,A0
 LEA OPLT,A1
 MOVEQ #7,D0
 BSR COPY
 MOVE.B $FF820A,SPAR4+3
 MOVE.L $70,SPAR1
 BSR TOPBRD
 BSR INTRO
 MOVE.L $120,SPAR2
 MOVE.L $118,SPAR3
 MOVE.B $FFFA09,SPAR4
 MOVE.B $FFFA07,SPAR4+1
 MOVE.B $FFFA13,SPAR4+2
 MOVE.L #RASTER2,$70

 MOVEQ #0,D0
 MOVEQ #0,D1
 BSR CAL3
 CLR.B FG1+4
 BSR CNFNT
 BSR PTFIL
 LEA PLT,A0
 LEA $FF8240,A1
 MOVEQ #7,D0
 BSR COPY
 BSR TBMK
 MOVE.L #RASTER3,$118
 ANDI.B #-$21,$FFFA09
 ANDI.B #-2,$FFFA07
 MOVE.L #RASTER1,$120
 ORI.B #1,$FFFA07
 ORI.B #1,$FFFA13
 MOVE.W #$2300,SR
 RTS
T=5
PTFIL:
 LEA SCR+(T*160),A1
 MOVEQ #9,D6
FIL3:
 LEA PATT,A0
 MOVEQ #31,D5
FIL2:
 MOVE.L (A0)+,D0
 MOVE.L (A0)+,D1
 MOVE.L (A0)+,D2
 MOVE.L (A0)+,D3
 MOVEQ #9,D4
FIL1:
 MOVE.L D0,(A1)+
 MOVE.L D1,(A1)+
 MOVE.L D2,(A1)+
 MOVE.L D3,(A1)+
 DBRA D4,FIL1
 DBRA D5,FIL2
 DBRA D6,FIL3
 LEA SCR,A0
 MOVE.W #199,D0
CFIL:
 CLR.L (A0)+
 DBRA D0,CFIL
 LEA SCR+(T*160),A0
 MOVEQ #39,D0
FIL5:
 CLR.W (A0)
 ADDQ.W #8,A0
 DBRA D0,FIL5
 LEA COLTAB+64+(T*2),A1
 MOVEQ #6,D1
FIL4:
 LEA COLTAB+(T*2),A0
 MOVEQ #15,D0
 BSR COPY
 DBRA D1,FIL4
 LEA COLTAB,A0
 LEA COLTAB4,A1
 MOVEQ #124,D0
 BSR COPY
 LEA FONT+(('Z'-32)*192),A0
 LEA SCR+32000+64+4,A1
 BSR CHAR
 LEA FONT+(('G'-32)*192),A0
 LEA SCR+32000+80+4,A1
 BSR CHAR
 RTS
CNFNT:
 LEA FONT,A0
 LEA FONT+8192,A1
CNV2:
 CMP.L #FONT+8192,A0
 BEQ CNV1
 MOVE.L (A0)+,(A1)+
 CLR.W (A1)+
 BRA CNV2
CNV1:
 LEA FONT+8192,A0
 LEA FONT,A1
 MOVE.W #3077,D0
 BSR COPY
 LEA FONT,A5
 LEA FONT+12288,A6
 MOVEQ #6,D7
CNV5:
 MOVE.L A5,A0
 MOVE.L A6,A1
 MOVE.W #3077,D0
 BSR COPY
 MOVE.L A6,A0
 BSR CNV3
 ADD.W #12288,A5
 ADD.W #12288,A6
 DBRA D7,CNV5
 RTS
CHAR:
 MOVEQ #31,D0
CH1:
 MOVE.W (A0)+,(A1)
 MOVE.W (A0)+,8(A1)
 ADDQ.W #2,A0
 ADD.W #160,A1
 DBRA D0,CH1
 RTS
CNV3:
 MOVE.W #2047,D0
CNV4:
 MOVE.W #0,CCR
 ROXR.W (A0)
 ROXR.W 2(A0)
 ROXR.W 4(A0)
 MOVE.W #0,CCR
 ROXR.W (A0)+
 ROXR.W (A0)+
 ROXR.W (A0)+
 DBRA D0,CNV4
 RTS
TBMK:
 LEA TXAD,A0
 CLR.W D0
 MOVE.W #99,D1
TMK1:
 MOVE.W D0,(A0)+
 ADD.W #192,D0
 DBRA D1,TMK1
 LEA LTBSL-(50*4),A0
 MOVE.L A0,A1
TMK2:
 CMP.L #LOGTB,A0
 BEQ TMK3
 MOVE.L -(A0),(A1)+
 JMP TMK2
TMK3:
 LEA CCSL1,A0
 MOVE.L A0,A1
TMK5:
 CMP.L #CCTAB,A0
 BEQ TMK4
 MOVE.W -(A0),(A1)+
 JMP TMK5
TMK4:
 RTS
COPY:
 MOVE.L (A0)+,(A1)+
 DBRA D0,COPY
 RTS
MUSIC:
 JSR JETR    ;PEK!
 CLR.W D0
 MOVE.B $FFFC02,D0
 TST.B KEYF
 BNE M10
 CMP.B #$3B,D0
 BNE M1
 CLR.L D0
 CLR.B D1
 BSR CAL1
M1:
 CMP.B #$3C,D0
 BNE M2
 MOVEQ #1,D1
 MOVEQ #1,D0
 BSR CAL1
M2:
 CMP.B #$3D,D0
 BNE M3
 MOVEQ #2,D1
 CLR.L D0
 BSR CAL2
M3:
 CMP.B #$3E,D0
 BNE M4
 MOVEQ #3,D1
 MOVEQ #1,D0
 BSR CAL2
M4:
 CMP.B #$3F,D0
 BNE M5
 MOVEQ #4,D1
 MOVEQ #2,D0
 BSR CAL2
M5:
 CMP.B #$40,D0
 BNE M6
 BSR CAL3
M6:
 CMP.B #$41,D0
 BNE M7
 MOVEQ #6,D1
 CLR.L D0
 BSR CAL4
M7:
 CMP.B #$42,D0
 BNE M8
 MOVEQ #7,D1
 MOVEQ #1,D0
 BSR CAL4
M8:
 CMP.B #$43,D0
 BNE M9
 BSR CAL5
M9:
 CMP.B #$44,D0
 BNE M10
 BSR CAL6
M10:
 BRA MUSIC
JETR:
 CMP.L #SCR-(32*160),PEK7+2
 BLE JET3
 SUB.L #160,PEK7+2
 MOVE.W SYNC,D0
JET2:
 CMP.W SYNC,D0
 BEQ JET2
 BSR JET4
 BSR JETP
 CMP.L #SCR+(100*160),A3
 BLO JET8
 CMP.L #SCR+(160*160),A3
 BHI JET6
 LEA JET+512,A0
 SUB.L #(20*160)-6,A3
 MOVEQ #15,D0
JET7:
 MOVE.W (A0),(A3)
 MOVE.W 8(A0),8(A3)
 ADD.W #16,A0
 ADD.W #160,A3
 DBRA D0,JET7
JET6:
 RTS
JETP:
PEK7:
 LEA SCR+(168*160)+48,A1
 MOVE.L A1,PEK8+2
 MOVE.L A1,A3
 LEA JET+1536,A0
 LEA JETX,A2
 MOVEQ #31,D0
JET1:
 MOVE.W (A0)+,D1
 MOVE.W (A0)+,D2
 MOVE.W D1,D3
 OR.W D2,D3
 NOT.W D3
 MOVE.W (A1),(A2)+
 MOVE.W 2(A1),(A2)+
 AND.W D3,(A1)
 AND.W D3,2(A1)
 OR.W D1,(A1)+
 OR.W D2,(A1)+
 MOVE.W (A0)+,(A1)+
 MOVE.W (A0)+,(A1)+

 MOVE.W (A0)+,D1
 MOVE.W (A0)+,D2
 MOVE.W D1,D3
 OR.W D2,D3
 NOT.W D3
 MOVE.W (A1),(A2)+
 MOVE.W 2(A1),(A2)+
 AND.W D3,(A1)
 AND.W D3,2(A1)
 OR.W D1,(A1)+
 OR.W D2,(A1)+
 MOVE.W (A0)+,(A1)+
 MOVE.W (A0)+,(A1)
 ADD.W #146,A1
 DBRA D0,JET1
 RTS
JET8:
 SUB.L #(19*160)-6,A3
 MOVEQ #15,D0
JET9:
 CLR.W (A3)
 CLR.W 8(A3)
 ADD.W #160,A3
 DBRA D0,JET9
 RTS
JET3:
 MOVE.L #$FF8240+30,PEK12+6
 MOVE.L #ZZAR,MUSIC+2
 RTS
JET4:
 LEA JETX,A0
PEK8:
 LEA SCR+40000,A1
 MOVEQ #31,D0
JET5:
 MOVE.W (A0)+,(A1)+
 MOVE.W (A0)+,(A1)+
 CLR.L (A1)+
 MOVE.W (A0)+,(A1)+
 MOVE.W (A0)+,(A1)+
 CLR.L (A1)
 ADD.W #148,A1
 DBRA D0,JET5
 RTS
CAL1:
 CMP.B NOWP,D1
 BEQ MBAC
 CLR.B MUFG
 MOVE.B D0,D2
 ADD.B #49,D2
 MOVE.B D2,MUT2+7
 MOVE.B D1,NOWP
 JSR MUSC1
 MOVE.L #MUSC1+274,MUPEK+2
 LEA MUT2,A0
 BSR XNOW
MBC1:
 ST KEYF
MBAC:
 ST MUFG
 RTS
CAL6:
 CMP.B #9,NOWP
 BEQ MBAC
 CLR.B MUFG
 MOVE.B #9,NOWP
 CLR.L D0
 BSR MUSC6+58
 MOVE.L #MUSC6+158,MUPEK+2
 LEA MUT5,A0
 BSR XNOW
 BRA MBC1
CAL2:
 CMP.B NOWP,D1
 BEQ MBAC
 CLR.B MUFG
 MOVE.B D0,D2
 ADD.B #49,D2
 MOVE.B D2,MUT4+7
 MOVE.B D1,NOWP
 JSR MUSC2
 MOVE.L #MUSC2+278,MUPEK+2
 LEA MUT4,A0
 BSR XNOW
 BRA MBC1
CAL3:
 CMP.B #5,NOWP
 BEQ MBAC
 CLR.B MUFG
 MOVE.B #5,NOWP
 CLR.L D0
 JSR MUSC3+84
 MOVE.L #MUSC3+180,MUPEK+2
 LEA MUTX,A0
 BSR XNOW
 BRA MBC1
CAL4:
 CMP.B NOWP,D1
 BEQ MBAC
 MOVE.B D0,D2
 ADD.B #49,D2
 MOVE.B D2,MUT1+7
 CLR.B MUFG
 MOVE.B D1,NOWP
 JSR MUSC4+1350
 MOVE.L #MUSC4+40,MUPEK+2
 LEA MUT1,A0
 BSR XNOW
 BRA MBC1
CAL5:
 CMP.B #8,NOWP
 BEQ MBAC
 CLR.B MUFG
 MOVE.B #8,NOWP
 JSR MUSC5+84
 MOVE.L #MUSC5+180,MUPEK+2
 LEA MUT3,A0
 BSR XNOW
 BRA MBC1
RASTER1:
 CMP.W #198,LINE    ;REACHED LAST?  226
 BEQ SKIP1          ;YES
PEK4:
 MOVE.W COLTAB4,$FF8240
PEK12:
 MOVE.W COLTAB1,COLTAB3
 ADDQ.L #2,PEK12+2
 ADDQ.L #2,PEK4+2
 ADDQ.W #1,LINE
 BCLR #0,$FFFA0F
 RTE
SKIP1:
 ADDQ.W #1,LINE
 DS.W 100,$4E71
 BCLR #1,$FF820A
 DS.W 16,$4E71
 BSET #1,$FF820A
 MOVE.L #$00600050,$FF8248
 ADDQ.L #2,PEK4+2
 BCLR #0,$FFFA0F
 RTE
RASTER2:
 CLR.W LINE
 CLR.B $FFFA1B
 MOVE.L #COLTAB4,PEK4+2
 MOVE.L #COLTAB1,PEK12+2
 MOVEM.L A0-A6/D0-D7,-(SP)
 CLR.L D0
 MOVEQ #1,D0
 MOVE.B D0,$FFFA21
 MOVE.B #8,$FFFA1B
 MOVE.W #$740,$FF8240
 MOVE.L #$00370026,$FF8248
 CLR.L D0
 TST.B MUFG
 BEQ VBLX1
MUPEK:
 JSR MUSC3+180
VBLX1:
 TST.B FG1+2
 BEQ SRL9
 LEA SCTB,A2
 LEA SCTB1,A3
PEK1:
 LEA SCR,A1
 MOVEQ #8,D1
SRL2:
 LEA FONT,A0
 ADD.W (A2)+,A0
 ADD.L (A3)+,A0
 MOVEQ #31,D0
SRL1:
 MOVE.W (A0)+,6(A1)
 MOVE.W (A0)+,14(A1)
 MOVE.W (A0)+,22(A1)
 ADD.W #160,A1
 DBRA D0,SRL1
 DBRA D1,SRL2
 SUB.L #320,PEK1+2
 CMP.L #SCR-(32*160),PEK1+2
 BHI SRL3
 MOVE.L #SCR,PEK1+2
 LEA SCTB,A0
 MOVE.W 2(A0),(A0)+
 MOVE.W 2(A0),(A0)+
 MOVE.W 2(A0),(A0)+
 MOVE.W 2(A0),(A0)+
 MOVE.W 2(A0),(A0)+
 MOVE.W 2(A0),(A0)+
 MOVE.W 2(A0),(A0)+
 MOVE.W 2(A0),(A0)+
 LEA SCTB2,A2
 MOVE.W 2(A2),(A2)+
 MOVE.W 2(A2),(A2)+
 MOVE.W 2(A2),(A2)+
 MOVE.W 2(A2),(A2)+
 MOVE.W 2(A2),(A2)+
 MOVE.W 2(A2),(A2)+
 MOVE.W 2(A2),(A2)+
 MOVE.W 2(A2),(A2)+
 CLR.W (A2)
 CLR.W D0
 ADD.L #1,PEK2+2
PEK2:
 MOVE.B TXTL-1,D0
 CMP.B #$FF,D0
 BNE SRL4
 MOVE.L #TXTL,PEK2+2
 MOVE.B TXTL,D0
SRL4:
 SUB.B #32,D0
 LEA TXAD,A1
 ADD.W D0,D0
 MOVE.W (A1,D0.W),(A0)
SRL3:
 TST.B FG1
 BEQ SRL8
 CLR.B FG1
 LEA SCTB1,A0
 LEA SCTB2,A1
 LEA SCTB3,A2
 MOVEQ #9,D1
SRL7:
 MOVE.W (A1),D0
 CMP.W #4*13,D0
 BNE SRL6
 MOVE.W #-4,D0
SRL6:
 ADDQ.W #4,D0
 MOVE.W D0,(A1)+
 MOVE.L (A2,D0.W),(A0)+
 DBRA D1,SRL7
 BRA SRL9
SRL8:
 ST FG1
SRL9:
 TST.B FG1+1
 BEQ LOG4
 LEA M,A0
 MOVEQ #31,D0
LOG3:
 CLR.L (A0)
 CLR.L 8(A0)
 CLR.L 16(A0)
 CLR.L 24(A0)
 ADD.W #160,A0
 DBRA D0,LOG3
 CLR.B FG1+1
LOG4:
 LEA LOGO,A0
PEK5:
 MOVE.L LOGTB,A1
PEK6:
 ADDQ.W #2,A1
 CLR.W -320(A1)
 CLR.W -312(A1)
 CLR.W -304(A1)
 CLR.W -296(A1)
 CLR.W -160(A1)
 CLR.W -152(A1)
 CLR.W -144(A1)
 CLR.W -136(A1)
 MOVEQ #31,D0
LOG1:
 MOVE.W (A0)+,(A1)
 MOVE.W (A0)+,8(A1)
 MOVE.W (A0)+,16(A1)
 MOVE.W (A0)+,24(A1)
 ADD.W #160,A1
 DBRA D0,LOG1
 CLR.W (A1)
 CLR.W 8(A1)
 CLR.W 16(A1)
 CLR.W 24(A1)
 CLR.W 160(A1)
 CLR.W 168(A1)
 CLR.W 176(A1)
 CLR.W 184(A1)
 CMP.L #LTBSL-4,PEK5+2
 BNE LOG2
 MOVE.W PEK6,D0
 MOVE.W SWIT,D1
 EXG D0,D1
 MOVE.W D0,PEK6
 MOVE.W D1,SWIT
 ST FG1+1
 MOVE.L #LOGTB-4,PEK5+2
LOG2:
 ADDQ.L #4,PEK5+2
 TST.B FG1+4
 BEQ NWW1
 LEA MUTB,A0
PEK17:
 LEA SCR+(216*160)+96+6,A2
 MOVE.L A2,A3
 MOVEQ #7,D1
NWW3:
 MOVE.L (A0)+,A1
 MOVE.L A3,A2
PEK18:
 MOVE.W #0,D0
NWW2:
 MOVE.W (A1)+,(A2)
 ADD.W #160,A2
 DBRA D0,NWW2
 ADDQ.W #8,A3
 DBRA D1,NWW3
 SUB.L #160,PEK17+2
 CMP.W #14,PEK18+2
 BGE NWW4
 ADDQ.W #1,PEK18+2
 BRA NWW1
NWW4:
 MOVE.L #SCR+(216*160)+96+6,PEK17+2
 CLR.W PEK18+2
 CLR.B FG1+4
 CLR.B KEYF
NWW1:
 TST.B FG1+5
 BEQ CYK5
 LEA COLTAB1+(126*2)+30,A0
 MOVE.W (A0),-30(A0)
 MOVEQ #14,D0
CYC1:
 MOVE.W -(A0),2(A0)
 DBRA D0,CYC1
 LEA COLTAB1+(126*2)+32,A0
 MOVE.W (A0),30(A0)
 MOVEQ #14,D0
CYC2:
 MOVE.W 2(A0),(A0)+
 DBRA D0,CYC2
 LEA COLTAB1+(126*2)+90,A0
 MOVE.W (A0),-30(A0)
 MOVEQ #14,D0
CYC3:
 MOVE.W -(A0),2(A0)
 DBRA D0,CYC3
 LEA COLTAB1+(126*2)+92,A0
 MOVE.W (A0),30(A0)
 MOVEQ #14,D0
CYC4:
 MOVE.W 2(A0),(A0)+
 DBRA D0,CYC4
 CLR.B FG1+5
 JMP CYK6
CYK5:
 LEA COLTAB1+40+54,A0
 MOVE.W (A0),-54(A0)
 MOVEQ #26,D0
CYC7:
 MOVE.W -(A0),2(A0)
 DBRA D0,CYC7
 LEA COLTAB1+40+56,A0
 MOVE.W (A0),70(A0)
 MOVEQ #34,D0
CYC8:
 MOVE.W 2(A0),(A0)+
 DBRA D0,CYC8
 ST FG1+5
CYK6:
VBLX:
 MOVEM.L (SP)+,A0-A6/D0-D7
VBL2:
 ADDQ.W #1,SYNC
 RTE
RASTER3:
 MOVE.W #$2300,SR
 RTE
CLS:
 LEA SCR,A0
 MOVE.W #7999,D0
CLS1:
 CLR.L (A0)+
 DBRA D0,CLS1
 RTS
INTRO:
 BSR CLS
 LEA SCR+48,A1
 MOVEQ #6,D0
INT1:
 LEA JET,A0
 MOVEQ #31,D1
INT2:
 MOVE.W (A0)+,(A1)+
 MOVE.W (A0),(A1)
 ADDQ.W #6,A0
 ADDQ.W #6,A1
 MOVE.W (A0)+,(A1)+
 MOVE.W (A0),(A1)
 ADDQ.W #6,A0
 ADD.W #150,A1
 DBRA D1,INT2
 DBRA D0,INT1
 LEA PALM1,A2
 BSR PALM
 LEA PLT1,A0
 LEA $FF8240,A1
 MOVEQ #7,D0
 BSR COPY
 MOVE.L #VBL2,$70
 MOVE.W #$2300,SR
 BSR JETP
 MOVE.W #$8800,A0
 MOVE.W #$8802,A1
 MOVE.B #7,(A0)
 OR.B #%00111111,(A1)
 BCLR #3,(A1)
 MOVE.B #8,(A0)
 MOVE.B #15,(A1)
 MOVE.B #6,(A0)
 MOVE.B #31,(A1)
 MOVE.W #199,D1
INWT:
 BSR SNC
 DBRA D1,INWT
 MOVE.B #31,D6
INT4:
 BSR SNC
 BSR JET4
 BSR JETP
 CMP.L #SCR-(32*160)+48,PEK7+2
 BEQ INT3
 SUB.L #160,PEK7+2
 TST.B D6
 BEQ INT4
 SUBQ.B #1,D6
 MOVE.W #$8800,A0
 MOVE.B #6,(A0)
 MOVE.B D6,2(A0)
 BRA INT4
INT3:
 BSR CLS
 MOVE.W #49,D1
INWT1:
 BSR SNC
 DBRA D1,INWT1
 MOVE.L #SCR+(200*160)+48,PEK7+2
 MOVE.L #SCR+40000,PEK8+2
 LEA PALM2,A2
 BSR PALM
IN31:
 BSR SNC
 BSR JET4
 BSR JETP
 CMP.L #SCR-(32*160)+48,PEK7+2
 BEQ IN32
 SUB.L #160,PEK7+2
 BRA IN31
IN32:
 BSR CLS
 MOVE.W #49,D1
INWT2:
 BSR SNC
 DBRA D1,INWT2
 MOVE.L #SCR+(230*160)+48,PEK7+2
 MOVE.L #SCR+40000,PEK8+2
 MOVE.W #$2700,SR
 RTS
PALM:
 MOVE.L (A2)+,A1
 CMP.L #-1,A1
 BEQ PAL2
 LEA JET+1024,A0
 MOVEQ #31,D0
PAL1:
 MOVE.L (A0)+,(A1)+
 MOVE.L (A0)+,(A1)+
 MOVE.L (A0)+,(A1)+
 MOVE.L (A0)+,(A1)
 ADD.W #148,A1
 DBRA D0,PAL1
 BRA PALM
PAL2:
 RTS
SNC:
 MOVE.W SYNC,D0
SNC1:
 CMP.W SYNC,D0
 BEQ SNC1
 RTS
SSCR:
PEK11:
 MOVE.W #0,D0
 CMP.W #15,D0
 BLO XSC3
 LEA SCBUF+8,A1
 CLR.W D0
PEK10:
 MOVE.B TXT1,D0
 CMP.B #$FF,D0
 BNE XSC2
 MOVE.L #TXT1,PEK10+2
 MOVE.B TXT1,D0
XSC2:
 ADDQ.L #1,PEK10+2
 SUB.W #32,D0
 LSL.L #5,D0
 LEA SFONT,A0
 ADD.L D0,A0
 MOVEQ #7,D0
XSC1:
 MOVE.W (A0)+,(A1)
 ADD.W #10,A1
 MOVE.W (A0)+,(A1)
 ADD.W #10,A1
 DBRA D0,XSC1
 CLR.W PEK11+2
XSC3:
 ADDQ.W #1,PEK11+2
 LEA SCBUF+(5*32),A0
 MOVEQ #15,D0
XSC4:
 MOVE.W #0,CCR
 ROXL.W -(A0)
 ROXL.W -(A0)
 ROXL.W -(A0)
 ROXL.W -(A0)
 ROXL.W -(A0)
 DBRA D0,XSC4
 BSR COL3
 BSR SNC
 LEA COLTAB3,A0
 LEA COLTAB,A1
 LEA COLTAB4,A2
 MOVE.W #249,D1
XX1:
 MOVE.W (A0)+,D0
 MOVE.W (A1)+,(A2)+
 TST.W D0
 BEQ XX2
 CMP.W #$666,-2(A2)
 BEQ XX2
 CMP.W #$555,-2(A2)
 BEQ XX2
 MOVE.W D0,-2(A2)
XX2:
 DBRA D1,XX1
 LEA SCBUF,A0
PEK19:
 LEA SCR-(16*160)+40+4,A1
 MOVEQ #15,D0
XSC5:
 MOVE.W (A0)+,(A1)
 MOVE.W (A0)+,8(A1)
 MOVE.W (A0)+,16(A1)
 MOVE.W (A0)+,24(A1)
 ADD.W #160,A1
 ADDQ.W #2,A0
 DBRA D0,XSC5
XRET: ;PEK
 NOP
 CMP.L #SCR+110*160+40+4,PEK19+2
 BEQ XSC6
 ADD.L #160,PEK19+2
 RTS
XSC6:
 MOVE.W #$4E75,XRET
 LEA LOGO1+2048,A0
 LEA SCR+(20*160)+32,A1
 MOVE.W #-1,D1
 MOVEQ #63,D0
SWE1:
 MOVEQ #3,D3
SWE2:
 MOVE.W (A0)+,(A1)+
 MOVE.W D1,(A1)+
 MOVE.W D1,(A1)+
 MOVE.W D1,(A1)+
 DBRA D3,SWE2
 ADD.W #128,A1
 DBRA D0,SWE1
 MOVE.W #$770,$FF8240+28
 RTS
ZZAR:
 ADDQ.W #1,ZZ2+2
 CMP.W #64,ZZ2+2
 BEQ ZZ3
 BSR SNC
 LEA LOGO1,A0
 LEA SCR+126*160+40,A1
 BSR ZZ2
 LEA LOGO1+512,A0
 LEA SCR+126*160+72,A1
 BSR ZZ2
 LEA LOGO1+1024,A0
 LEA SCR+126*160+104,A1
 BSR ZZ2
 BSR SNC
 BSR SNC
 RTS
ZZ2:  ;PEK!
 MOVE.W #0,D1
ZZ1:
 MOVE.W (A0)+,D0
 OR.W D0,(A1)+
 OR.W D0,(A1)+
 OR.W D0,(A1)+
 MOVE.W D0,(A1)+
 MOVE.W (A0)+,D0
 OR.W D0,(A1)+
 OR.W D0,(A1)+
 OR.W D0,(A1)+
 MOVE.W D0,(A1)+
 MOVE.W (A0)+,D0
 OR.W D0,(A1)+
 OR.W D0,(A1)+
 OR.W D0,(A1)+
 MOVE.W D0,(A1)+
 MOVE.W (A0)+,D0
 OR.W D0,(A1)+
 OR.W D0,(A1)+
 OR.W D0,(A1)+
 MOVE.W D0,(A1)
 ADD.W #160-30,A1
 DBRA D1,ZZ1
 RTS
ZZ3:
 LEA LOGO1+1536,A0
 LEA SCR+(80*160)+120+6,A1
 MOVEQ #63,D0
SELE1:
 MOVE.W (A0)+,(A1)
 MOVE.W (A0)+,8(A1)
 MOVE.W (A0)+,16(A1)
 MOVE.W (A0)+,24(A1)
 ADD.W #160,A1
 DBRA D0,SELE1
 LEA NOWPL,A0
 LEA SCR+(184*160)+120+6,A1
 MOVEQ #15,D0
NOW1:
 MOVE.W (A0)+,(A1)
 MOVE.W (A0)+,8(A1)
 ADD.W #160,A1
 DBRA D0,NOW1
 ST FG1+4
 ST FG1+2
 MOVE.L #SSCR,MUSIC+2
 RTS
COL3:
 LEA COLTAB3,A0
 MOVEQ #124,D0
C1:
 CLR.L (A0)+
 DBRA D0,C1
PEK13:
 MOVE.W CCTAB,D0
 CMP.W #-1,D0
 BNE C2
 MOVE.L #CCTAB-2,PEK13+2
 MOVE.W CCTAB,D0
C2:
 LEA C3C,A0
 BSR C3
PEK14:
 MOVE.W CCTAB+6,D0
 CMP.W #-1,D0
 BNE C4
 MOVE.L #CCTAB-2,PEK14+2
 MOVE.W CCTAB,D0
C4:
 LEA C3C1,A0
 BSR C3
PEK15:
 MOVE.W CCTAB+12,D0
 CMP.W #-1,D0
 BNE C5
 MOVE.L #CCTAB-2,PEK15+2
 MOVE.W CCTAB,D0
C5:
 LEA C3C2,A0
 BSR C3
PEK16:
 MOVE.W CCTAB+18,D0
 CMP.W #-1,D0
 BNE C6
 MOVE.L #CCTAB-2,PEK16+2
 MOVE.W CCTAB,D0
C6:
 LEA C3C3,A0
 BSR C3
 ADDQ.L #2,PEK13+2
 ADDQ.L #2,PEK14+2
 ADDQ.L #2,PEK15+2
 ADDQ.L #2,PEK16+2
 RTS
C3:
 ADD.W D0,D0
 LEA COLTAB3,A1
 ADD.W D0,A1
 MOVE.L (A0)+,(A1)+
 MOVE.L (A0)+,(A1)+
 RTS
XNOW:
 CLR.B FG1+4
 LEA MUTB,A1
 MOVEQ #7,D0
XN1:
 CLR.W D1
 MOVE.B (A0)+,D1
 SUB.W #32,D1
 LSL.W #5,D1
 LEA SFONT,A2
 ADD.W D1,A2
 ADDQ.W #2,A2
 MOVE.L A2,(A1)+
 DBRA D0,XN1
 ST FG1+4
 RTS
TOPBRD:
 LEA $FF8240,A0
 MOVEQ #7,D0
TCLR:
 CLR.L (A0)+
 DBRA D0,TCLR
 LEA BUFF,A0
 MOVE.W #1499,D0
TCLR1:
 CLR.L (A0)+
 DBRA D0,TCLR1
 MOVE.L #RASTER,$70
 MOVE.W #$2300,SR
 JSR MIDISC
TMAIN:
 JSR SCROL1
 TST.B D6
 BNE ESC
 LEA SCR,A1
 JSR DUMP1
 CMP.B #$39,$FFFC02
 BNE TMAIN
ESC:
 MOVE.W #$2700,SR
 RTS
CALP:
 MOVEQ #7,D0
CAL511:
 MOVE.L (A0)+,(A1)+
 DBRA D0,CAL511
 RTS
RASTER:
 bclr #1,$ff820a
 MOVEM.L A0-A6/D0-D7,-(SP)
 MOVE.W #$700,$FF8242
 MOVE.W SR,-(A7)
 ORI.W #$700,SR
 LEA $FF8242,A4
 LEA $FF8209,A5
 LEA (A4),A0
 LEA TAB1,A6
 LEA TAB2,A3

 MOVE.W #31,D7
 CLR.L D0
LOP1:
 TST.B (A5)
 BEQ.S LOP1
 MOVE.B (A5),D0
 ADDA.L D0,A6
 JMP (A6)
TAB1:
 DS.W 118,$4E71
LOP2:
 MOVE.W (A3)+,(A0)
 MOVE.W #24,D6
LOP3:
 NOP
 DBRA D6,LOP3
 DS.W 19,$4E71
 DBRA D7,LOP2
 MOVE.W (A7)+,SR
 ADDQ.W #1,SYNC
SLUT:
 CLR.L $FF8240
 bset #1,$ff820a
 MOVEM.L (SP)+,A0-A6/D0-D7
 RTE
SCROL1:
 MOVE.W #1,D1
 CMP.W #8,D1
 BNE SCIP3
 CLR.W D0
TXPEK:
 MOVE.B TXSTART,D0
 ADDQ.L #1,TXPEK+2
 CMP.B #$FF,D0
 BNE SCIP2
 ST D6
 RTS
SCIP2:
 SUB.B #32,D0
 LSL.W #7,D0
 LEA FONT,A0
 ADD.L D0,A0
 LEA BUFF+160,A1
 MOVEQ #15,D0
LLOP6:
 MOVE.W (A0)+,(A1)
 MOVE.W (A0)+,8(A1)
 ADD.W #160+16,A1
 MOVE.W (A0)+,(A1)
 MOVE.W (A0)+,8(A1)
 ADD.W #160+16,A1
 DBRA D0,LLOP6
 CLR.W D1
SCIP3:
 ADDQ.W #1,D1
 MOVE.W D1,SCROL1+2
 LEA BUFF+168,A0
 MOVEQ #31,D1
LOP4:
 MOVEQ #3,D0
LLOP2:
 MOVE #0,CCR
 ROXL.W (A0)
 ROXL.W -8(A0)
 ROXL.W -16(A0)
 ROXL.W -24(A0)
 ROXL.W -32(A0)
 ROXL.W -40(A0)
 ROXL.W -48(A0)
 ROXL.W -56(A0)
 ROXL.W -64(A0)
 ROXL.W -72(A0)
 ROXL.W -80(A0)
 ROXL.W -88(A0)
 ROXL.W -96(A0)
 ROXL.W -104(A0)
 ROXL.W -112(A0)
 ROXL.W -120(A0)
 ROXL.W -128(A0)
 ROXL.W -136(A0)
 ROXL.W -144(A0)
 ROXL.W -152(A0)
 ROXL.W -160(A0)
 ROXL.W -168(A0)
 DBRA D0,LLOP2
 ADD.L #176,A0
 DBRA D1,LOP4
 CLR.B D6
 RTS
DUMP1:
 JSR SNC
 LEA BUFF,A0
 MOVE.W #31,D0
LOP5:
 MOVE.W #1,D1
LOP7:
 MOVE.W (A0),(A1)
 MOVE.W 8(A0),8(A1)
 MOVE.W 16(A0),16(A1)
 MOVE.W 24(A0),24(A1)
 MOVE.W 32(A0),32(A1)
 MOVE.W 40(A0),40(A1)
 MOVE.W 48(A0),48(A1)
 MOVE.W 56(A0),56(A1)
 MOVE.W 64(A0),64(A1)
 MOVE.W 72(A0),72(A1)
 ADD.W #80,A0
 ADD.W #80,A1
 DBRA D1,LOP7
 ADD.W #16,A0
 DBRA D0,LOP5
 RTS
MIDISC:
 LEA STRI2+8,A0
 MOVEQ #$20,D0
 BSR CALC
 LEA STRI2,A0
 MOVEQ #29,D0
 BSR MIDIS
 RTS
MIDIS:
 LEA $FFFFFC04,A1
NOPE:
 MOVE.B (A1),D1
 BTST #1,D1
 BEQ NOPE
 MOVE.B (A0)+,2(A1)
 DBRA D0,NOPE
 RTS
CALC:
 CMP.B #$F7,1(A0)
 BEQ CALC1
 ADD.B (A0)+,D0
 BCLR #7,D0
 BRA CALC
CALC1:
 MOVE.B #128,D1
 SUB.B D0,D1
 MOVE.B D1,(A0)
 RTS
RESETR:
 MOVE.W #$2700,SR
 MOVE.B #2,$FFFF820A
 LEA $D50,A7
 CLR.W $FF8240
 MOVE.W #$070,$FF8242
 MOVE.W #$700,$FF8244
 MOVE.W #$770,$FF8246
 LEA SCR,A0
 MOVE.W #7999,D0
RS9:
 CLR.L (A0)+
 DBRA D0,RS9
 PEA RESTX
 MOVE.W #9,-(SP)
 TRAP #1
 ADDQ.L #6,SP
 CLR.L $426
MFP=$FFFA00
IERA=$07
IERB=$09
IPRA=$0B
ISRA=$0F
IMRA=$13
IMRB=$15
VECTOR=$17
TACR=$19
TADR=$1F
ISRVEC=$134
SCREG=$FF8800
SCDATA=$FF8802
 MOVE.B #0,SCREG ;CHANNEL A
 MOVE.B #0,SCDATA
 MOVE.B #1,SCREG
 MOVE.B #0,SCDATA
 MOVE.B #2,SCREG ;CHANNEL B
 MOVE.B #0,SCDATA
 MOVE.B #3,SCREG
 MOVE.B #0,SCDATA
 MOVE.B #4,SCREG ;CHANNEL C
 MOVE.B #0,SCDATA
 MOVE.B #5,SCREG
 MOVE.B #0,SCDATA
 MOVE.B #7,SCREG ;SET UP CHANNEL MIXING & PORT 'A' I/O
 MOVE.B #$FF,SCDATA
 MOVE.B #8,SCREG ;SET ALL VOLUMES TO ZERO
 MOVE.B #0,SCDATA
 MOVE.B #9,SCREG
 MOVE.B #0,SCDATA
 MOVE.B #10,SCREG
 MOVE.B #0,SCDATA
SAMPLAY:
 LEA SCREG,A1
 LEA SND_OUT,A0
IREPLAY:
 CLR.W D0
SAMPEK:
 MOVE.B SAMPLE,D0 ;READ FROM RAM
 LSL.W #3,D0      ;DOUBLE LONG WORD OFFSET
 CMP.L #SMPSLUT,SAMPEK+2     ;EXCEDED END STOP
 BGT.S HALTREP    ;BRANCH IF SO
SAMBACK:
INTOUTP:
 ADD.W D0,A0
 MOVE.L (A0)+,D0   ;GET DATA #1
 MOVEP.L D0,0(A1)       ;PLAY #1
 MOVE.W (A0),D0   ;GET DATA #2
 MOVEP.W D0,0(A1)       ;PLAY #2
 ADDQ.L #1,SAMPEK+2
 MOVEQ #26,D0
SAMPAS:
 DBRA D0,SAMPAS
 JMP SAMPLAY
HALTREP:
 MOVE.L #SAMPLE,SAMPEK+2
 JMP SAMBACK
RESTX:
 DC.B 27,'Y',43,33,27,'b',1,'THANK YOU FOR WATCHING',27,'b',2,'  DEMO 3'
 DC.B 27,'Y',45,33,27,'b',1,'SEND INTROS, DEMOS, OPINONS ETC. TO:'
 DC.B 27,'Y',53,34,"COMING SOON FROM ZZAP GAMES & CCK:"
 DC.B 27,'Y',54,39,"THE '",27,"b",2,"SKINNY PUPPY DEMO",27,'b',1,"'."
 DC.B 27,'Y',47,39,27,'b',3,'ZZAP GAMES'
 DC.B 27,'Y',48,39,'C/O VILLE KRUMLINDE'
 DC.B 27,'Y',49,39,'TORSVIKSSVANGEN 17'
 DC.B 27,'Y',50,39,'S-181 34 LIDINGO'
 DC.B 27,'Y',51,39,'SWEDEN',0
 ALIGN.W
SND_OUT:
 dc.w $80c,$90b,$a09,0,$80c,$90b,$a09,0
 dc.w $80d,$908,$a08,0,$80b,$90b,$a0b,0
 dc.w $80d,$909,$a05,0,$80c,$90b,$a08,0
 dc.w $80d,$909,$a02,0,$80d,$908,$a06,0
 dc.w $80c,$90b,$a07,0,$80d,$907,$a07,0
 dc.w $80c,$90b,$a06,0,$80c,$90a,$a09,0
 dc.w $80b,$90b,$a0a,0,$80c,$90b,$a02,0
 dc.w $80c,$90b,$a00,0,$80c,$90a,$a08,0

 dc.w $80d,$906,$a04,0,$80d,$905,$a05,0
 dc.w $80d,$905,$a04,0,$80c,$909,$a09,0
 dc.w $80d,$904,$a03,0,$80b,$90b,$a09,0
 dc.w $80c,$90a,$a05,0,$80b,$90a,$a0a,0
 dc.w $80c,$909,$a08,0,$80b,$90b,$a08,0
 dc.w $80c,$90a,$a00,0,$80c,$90a,$a00,0
 dc.w $80c,$909,$a07,0,$80b,$90b,$a07,0
 dc.w $80c,$909,$a06,0,$80b,$90b,$a06,0

 dc.w $80b,$90a,$a09,0,$80b,$90b,$a05,0
 dc.w $80a,$90a,$a0a,0,$80b,$90b,$a02,0
 dc.w $80b,$90a,$a08,0,$80c,$907,$a07,0
 dc.w $80c,$908,$a04,0,$80c,$907,$a06,0
 dc.w $80b,$909,$a09,0,$80c,$906,$a06,0
 dc.w $80a,$90a,$a09,0,$80c,$907,$a03,0
 dc.w $80b,$90a,$a05,0,$80b,$909,$a08,0
 dc.w $80b,$90a,$a03,0,$80a,$90a,$a08,0

 dc.w $80b,$90a,$a00,0,$80b,$909,$a07,0
 dc.w $80b,$908,$a08,0,$80a,$90a,$a07,0
 dc.w $80a,$909,$a09,0,$80c,$901,$a01,0
 dc.w $80a,$90a,$a06,0,$80b,$908,$a07,0
 dc.w $80a,$90a,$a05,0,$80a,$909,$a08,0
 dc.w $80a,$90a,$a02,0,$80a,$90a,$a01,0
 dc.w $80a,$90a,$a00,0,$809,$909,$a09,0
 dc.w $80a,$908,$a08,0,$80b,$908,$a01,0

 dc.w $80a,$909,$a06,0,$80b,$907,$a04,0
 dc.w $80a,$909,$a05,0,$809,$909,$a08,0
 dc.w $80a,$909,$a03,0,$80a,$908,$a06,0
 dc.w $80a,$909,$a00,0,$809,$909,$a07,0
 dc.w $809,$908,$a08,0,$80a,$908,$a04,0
 dc.w $809,$909,$a06,0,$80a,$908,$a01,0
 dc.w $809,$909,$a05,0,$809,$908,$a07,0
 dc.w $808,$908,$a08,0,$809,$909,$a02,0

 dc.w $809,$908,$a06,0,$809,$909,$a00,0
 dc.w $809,$907,$a07,0,$808,$908,$a07,0
 dc.w $809,$907,$a06,0,$809,$908,$a02,0
 dc.w $808,$908,$a06,0,$809,$906,$a06,0
 dc.w $808,$907,$a07,0,$808,$908,$a04,0
 dc.w $808,$907,$a06,0,$808,$908,$a02,0
 dc.w $807,$907,$a07,0,$808,$906,$a06,0
 dc.w $808,$907,$a04,0,$807,$907,$a06,0

 dc.w $808,$906,$a05,0,$808,$906,$a04,0
 dc.w $807,$906,$a06,0,$807,$907,$a04,0
 dc.w $808,$905,$a04,0,$806,$906,$a06,0
 dc.w $807,$906,$a04,0,$807,$905,$a05,0
 dc.w $806,$906,$a05,0,$806,$906,$a04,0
 dc.w $806,$905,$a05,0,$806,$906,$a02,0
 dc.w $806,$905,$a04,0,$805,$905,$a05,0
 dc.w $806,$905,$a02,0,$805,$905,$a04,0

 dc.w $805,$904,$a04,0,$805,$905,$a02,0
 dc.w $804,$904,$a04,0,$804,$904,$a03,0
 dc.w $804,$904,$a02,0,$804,$903,$a03,0
 dc.w $803,$903,$a03,0,$803,$903,$a02,0
 dc.w $803,$902,$a02,0,$802,$902,$a02,0
 dc.w $802,$902,$a01,0,$801,$901,$a01,0
 dc.w $802,$901,$a00,0,$801,$901,$a00,0
 dc.w $801,$900,$a00,0,$800,$900,$a00,0

 dc.w $80e,$90d,$a0c,0,$80f,$903,$a00,0
 dc.w $80f,$903,$a00,0,$80f,$903,$a00,0
 dc.w $80f,$903,$a00,0,$80f,$903,$a00,0
 dc.w $80f,$903,$a00,0,$80e,$90d,$a0b,0
 dc.w $80e,$90d,$a0b,0,$80e,$90d,$a0b,0
 dc.w $80e,$90d,$a0b,0,$80e,$90d,$a0b,0
 dc.w $80e,$90d,$a0b,0,$80e,$90d,$a0b,0
 dc.w $80e,$90d,$a0a,0,$80e,$90d,$a0a,0

 dc.w $80e,$90d,$a0a,0,$80e,$90d,$a0a,0
 dc.w $80e,$90c,$a0c,0,$80e,$90d,$a00,0
 dc.w $80d,$90d,$a0d,0,$80d,$90d,$a0d,0
 dc.w $80d,$90d,$a0d,0,$80d,$90d,$a0d,0
 dc.w $80d,$90d,$a0d,0,$80d,$90d,$a0d,0
 dc.w $80e,$90c,$a0b,0,$80e,$90c,$a0b,0
 dc.w $80e,$90c,$a0b,0,$80e,$90c,$a0b,0
 dc.w $80e,$90c,$a0b,0,$80e,$90c,$a0b,0

 dc.w $80e,$90c,$a0b,0,$80e,$90c,$a0b,0
 dc.w $80e,$90c,$a0a,0,$80e,$90c,$a0a,0
 dc.w $80e,$90c,$a0a,0,$80e,$90c,$a0a,0
 dc.w $80d,$90d,$a0c,0,$80d,$90d,$a0c,0
 dc.w $80e,$90c,$a09,0,$80e,$90c,$a09,0
 dc.w $80e,$90c,$a05,0,$80e,$90c,$a00,0
 dc.w $80e,$90c,$a00,0,$80e,$90b,$a0b,0
 dc.w $80e,$90b,$a0b,0,$80e,$90b,$a0b,0

 dc.w $80e,$90b,$a0b,0,$80e,$90b,$a0a,0
 dc.w $80e,$90b,$a0a,0,$80e,$90b,$a0a,0
 dc.w $80d,$90d,$a0b,0,$80d,$90d,$a0b,0
 dc.w $80d,$90d,$a0b,0,$80e,$90b,$a09,0
 dc.w $80e,$90b,$a09,0,$80e,$90b,$a09,0
 dc.w $80d,$90c,$a0c,0,$80d,$90d,$a0a,0
 dc.w $80e,$90b,$a07,0,$80e,$90b,$a00,0
 dc.w $80e,$90b,$a00,0,$80d,$90d,$a09,0

 dc.w $80d,$90d,$a09,0,$80e,$90a,$a09,0
 dc.w $80d,$90d,$a08,0,$80d,$90d,$a07,0
 dc.w $80d,$90d,$a04,0,$80d,$90d,$a00,0
 dc.w $80e,$90a,$a04,0,$80e,$909,$a09,0
 dc.w $80e,$909,$a09,0,$80d,$90c,$a0b,0
 dc.w $80e,$909,$a08,0,$80e,$909,$a08,0
 dc.w $80e,$909,$a07,0,$80e,$908,$a08,0
 dc.w $80e,$909,$a01,0,$80c,$90c,$a0c,0

 dc.w $80d,$90c,$a0a,0,$80e,$908,$a06,0
 dc.w $80e,$907,$a07,0,$80e,$908,$a00,0
 dc.w $80e,$907,$a05,0,$80e,$906,$a06,0
 dc.w $80d,$90c,$a09,0,$80e,$905,$a05,0
 dc.w $80e,$904,$a04,0,$80d,$90c,$a08,0
 dc.w $80d,$90b,$a0b,0,$80e,$900,$a00,0
 dc.w $80d,$90c,$a06,0,$80d,$90c,$a05,0
 dc.w $80d,$90c,$a02,0,$80c,$90c,$a0b,0

 dc.w $80c,$90c,$a0b,0,$80d,$90b,$a0a,0
 dc.w $80d,$90b,$a0a,0,$80d,$90b,$a0a,0
 dc.w $80d,$90b,$a0a,0,$80c,$90c,$a0a,0
 dc.w $80c,$90c,$a0a,0,$80c,$90c,$a0a,0
 dc.w $80d,$90b,$a09,0,$80d,$90b,$a09,0
 dc.w $80d,$90a,$a0a,0,$80d,$90a,$a0a,0
 dc.w $80d,$90a,$a0a,0,$80c,$90c,$a09,0
 dc.w $80c,$90c,$a09,0,$80c,$90c,$a09,0

 dc.w $80d,$90b,$a06,0,$80c,$90b,$a0b,0
 dc.w $80c,$90c,$a08,0,$80d,$90b,$a00,0
 dc.w $80d,$90b,$a00,0,$80c,$90c,$a07,0
 dc.w $80c,$90c,$a06,0,$80c,$90c,$a05,0
 dc.w $80c,$90c,$a03,0,$80c,$90c,$a01,0
 dc.w $80c,$90b,$a0a,0,$80d,$90a,$a05,0
 dc.w $80d,$90a,$a04,0,$80d,$90a,$a02,0
 dc.w $80d,$909,$a08,0,$80d,$909,$a08,0
MUTX: DC.B 'WARHAWK '
MUT1: DC.B 'OUTRUN 1'
MUT2: DC.B 'ICEPLC 1'
MUT3: DC.B ' THRUST '
MUT4: DC.B 'ENDURO 1'
MUT5: DC.B 'TDR CATS'
 ALIGN.W
CCTAB:
 DC.W 0,0,1,1,2,2,3,3,4,5,6,7,8,10,12,14,16,18,20,22,24,26,28,30,32,34
 DC.W 36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78
 DC.W 80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112
 DC.W 114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144
 DC.W 146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176
 DC.W 178,180,182,184,186,188,190,192,194,196,198,200
 DC.W 201,202,203,204,205,206,206,207,207,208,208,209,209
CCSL1:
 DS.W (CCSL1-CCTAB)/2
 DC.W $FFFF
CCSL2:
PALM1: DC.L SCR+144,SCR+50*160+80,SCR+100*160+64,SCR+(70*160),SCR+(150*160)+104,-1
PALM2: DC.L SCR+96,SCR+100*160,SCR+168*160+80,SCR+80*160+72,SCR+110*160+104,-1
TXT1:
 DC.B 'PRESS KEYS F1-F10 TO CHOOSE TUNE. '
 DC.B 'ZZAP GAMES WOULD LIKE TO SEND GREETINGS TO THE FOLLOWING ',98,99,100,101,102,103,104,'ST M-CODE EXPERTS: '
 DC.B 'THE EXCEPTIONS (',96,97,'), THE COCA-COLA KID (',94,95,'), CCS, HCC, LEVEL 16, SYNC, ZAXX, BEAR OF BLOCKBUSTERS, '
 DC.B 'GIGABYTE CREW, THE MASTER, WAS (NOT WAS), GUIDE, TCB, BLADERUNNER, TSUNOO, TNT, DMA.....'
 DC.B "F**KINGS TO: THE SADISTIC VIRUS MAKERS, UNPROTECTED OR ALREADY CRACKED GAMES CRACKERS, MARGARETA P, THE SWEDISH FILM-"
 DC.B 'CENSOR+OTHER PEOPLE WHO LOVE TO MAKE OTHER PEOPLES DECISIONS, ASCII CHANGE SUCKERS, JOHAN W AND GURAN B...'
 DC.B 'HI TO MARTIN ST & SV, PATRIK E & S, VILLE G, TORE N, JOHAN T, HENRIK E & I, HERGE, OLOV A, DANIEL A, LUDDE B, '
 DC.B "MATTIAS E, LASSE E (DON'T FORGET THE ST JUST BECAUSE YOU BOUGHT AN A**GA!)..."
 DC.B "PRESS KEYS F1-F10 TO CHOOSE TUNE...THIS TIME THE MUSIC IS RIPPED FROM THE FOLLOWING GAMES: ICEPALACE, THE LATEST GAME "
 DC.B ' FROM ELITE PROGRAMMED BY THE VERY SKILLED M-CODER TIM MOORE (METROCROSS,SOLOMONS KEY). TWO DAVID W TUNES...'
 DC.B "ENDURO RACER, A GAME THAT I DON'T LIKE. THREE SONGS BY DAVID W...WARHAWK, THAT OLD SHOOT'EM UP GAME. I THINK IT'S BORIN"
 DC.B "G COMPARED WITH XENON. ONE BRILLIANT ROB HUBBARD SONG...OUTRUN, THE BRILLIANT ARCADE CONVERSION. I THINK IT'S GREAT,BUT"
 DC.B " FOR SOME STRANGE REASON MOST PEOPLE DON'T. TWO DAVID W ARCADE SONGS...THRUST, I THINK THAT THIS CONVERSION FROM THE "
 DC.B "SUPERB C-64 GAME ISN'T AS GOOD AS THE ORIGINAL. THE MUSIC IS A WHOLE DIFFERENT STORY. IT'S BRILLIANT! IM SURE THAT TEX "
 DC.B "MEMBER MAD MAX AGREES THAT IT BEAT HIS 'BIG' DEMO C-64 CONVERSION WITHOUT COMPETION. ONE ROB HUBBARD SONG."
 DC.B "..THUNDER CATS, A CANT REALLY SAY ANYTHING ABOUT THIS GAMES QUALITY, SINCE MY COPY DOESN'T WORK. THE BRILLIANT INTRO "
 DC.B "BY UNION/",96,97," WORKS HOWEVER, AND IV'E GOT A FEELING THAT THE INTRO IS BETTER THAN THE GAME ITSELF! THIS PIECE "
 DC.B "OF MUSIC WAS ADDED IN THE LAST MINUTE, SO THAT'S WHY IT'S NOT INCLUDED IN THE MUSIC LIST. SORRY ABOUT THAT. A SPECIAL "
 DC.B "GREETING TO UNION/",96,97," FOR THEIR REALLY SUPERB THUNDERCATS INTRO! TC IS A DAVID WHITTAKER SONG."
 DC.B "......OK,......TEXTLINE RESET!......"
 DC.B $FF
 ALIGN.W
TXTL:
 DC.B "HELLO ALL DEMO FANTA ST S!!!     OK,     FASTEN SEAT BELTS.    NO SMOKING.      "
 DC.B "GET READY FOR ABOUT 8K OF POINTLESS SCROLL TEXT...           "
 DC.B "WELCOME TO THE THIRD DEMO BY ZZAP GAMES. SEE THE SMALL SCROLL TEXT FOR GREETINGS. "
 DC.B "THESE ARE THE CREDITS: STALIN; MCODE, BOOT CODE, RASTER AND GRAPHICS DESIGN, SCROLL TEXT ETC. ETC.   YES, THAT'S RIGHT "
 DC.B "STALIN WENT ALONE THIS TIME AND MADE THE WHOLE DEMO HIMSELF FROM SCRATCH IN JUST UNDER TWO WEEKS! WHY? WELL IT'S SUMMER"
 DC.B " (JULY) AND I AM SITTING IN OUR SUMMER COTTAGE WHICH I'VE BEEN IN FOR THE LAST TWO WEEKS. IT'S ON A QUIET ISLAND IN THE"
 DC.B " ARCHEPELAGO OF STOCKHOLM. SO, WHEN IT RAINS, IT'S PERFECT FOR PROGRAMMING! WHAT? YOU ARE NOT INTERESTED IN MY "
 DC.B "PROGRAMMING HABITS?   OH...   WELL, A QUICK JOKE THEN: A BOY WALKS INTO THE CLASSROOM WITH A FROG ON HIS HEAD. THE "
 DC.B "TEACHER SAYS 'WHERE DOES THAT COME FROM?'. 'WELL, IT STARTED AS A PAIN IN THE BACK' THE FROG ANSWERED...    HA HA!  "
 DC.B "OK, I UNDERSTAND: NOT FUNNY, UNTASTY, SICK... SOME OF YOU WHO WATCHES THIS DEMO MIGHT SAY 'DEMO NR 3? I HAVEN'T SEEN "
 DC.B "THE OTHER TWO.' WELL, HERE IS THE EXPLAINATION: ZZAPDEMO NR 1 WAS WRITTEN ABOUT A YEAR AGO NOW (WHEN I BOUGHT MY ST) "
 DC.B "AND WASN'T REALLY A DEMO. IT WAS JUST 5K IN LENGHT! ALL THAT HAPPEND WERE SOME LETTERS BOUNCING UP AND DOWN TOGETHER "
 DC.B "WITH SOME SIMPLE RASTERS. ON THE CONTRARY, ZZAP DEMO 2 (THE LAZER DEMO), WAS FINISHED ONLY ABOUT 3 WEEKS AGO NOW, "
 DC.B "AND IT FILLS UP A WHOLE SINGLE SIDED DISK. THE COCA-COLA KID DID THE GRAPHICS AND RASTER DESIGN ON THAT ONE, SO IT'S "
 DC.B "MORE GOOD LOOKING THAN THIS DEMO. IF YOU HAVEN'T GOT THAT DEMO, AND IF YOU LIKED THIS ONE, PLEASE SEND US A DISK "
 DC.B "AND WE WILL BE MORE THAN HAPPY TO SEND IT TO YOU. BY THE WAY THIS DEMO ,AS WELL AS TLD, IS SHARE WARE AND MAY BE "
 DC.B "COPIED FREELY. DONATIONS HOWEVER, ARE MORE THAN WELCOME (OF COURSE!) AND CAN BE SENT TO OUR ADRESS.   LET'S TALK "
 DC.B "ABOUT PROGRAMMING FOR A WHILE. 68000 MC IS REALLY GREAT TO PROGRAM, IT'S SO EASY COMPARED WITH THE 6810 OR THE Z80A."
 DC.B "SO, IF YOU OWNED A C-64 OR A ZX SPECTRUM BEFORE YOU BOUGHT YOUR ST AND YOU HAD TROUBLE WITH LEARNING MC, NOW IS "
 DC.B "THE TIME TO TRY AGAIN. I ASK YOU: WOULDN'T IT BE GREAT TO KNOW HOW TO WRITE YOUR OWN DEMOS, WITH RASTERS, BORDERGX ETC?"
 DC.B " YOU WILL WITHOUT DOUBT ANSWER YES. WELL, PUT DOWN THE JOYSTICK FOR A WHILE, AND GO OUT TO BUY SOME MC BOOKS. "
 DC.B "I AFRAID I DON'T KNOW ABOUT SOME GOOD BOOK FOR BEGINNERS, SINCE I ALREADY KNEW Z80A WHEN I BOUGHT THE ST, BUT A "
 DC.B "REALLY ESSENTIAL BOOK IS 'ST INTERNALS' FROM ABACUS. I CAN ALMOST GUARANTEE THAT EVERY ST PROGRAMMER HAVE READ A COPY "
 DC.B "OF THIS ONE. HOWEVER, IT DOESESN'T TEACH YOU MC, SO BUY A BEGINNERS BOOK FIRST. ANOTHER BOOK THAT A CAN RECOMMEND "
 DC.B "FOR THOSE WITH FORMER MC EXPERIENCE IS '68000 PROGRAMMING', A SYBEX BOOK WRITTEN BY STEVE WILLIAMS. ALL THE 68000 "
 DC.B "COMMANDS ARE EXPLAINED IN DETAIL.    OK, LET'S CHANGE SUBJECT TO A TOTALLY IRRELEVANT ONE: 'FILMS AND BOOKS'. SO WHAT "
 DC.B "HAVE I GOT TO SAY ABOUT THAT? WELL, FIRST I'VE GOT A WARNING FOR YOU: HAVE YOU SEEN RAMBO 3?  WELL, DONT!!!! "
 DC.B "IT'S THE MOST GODDAMN AWFULL FILM IV'E SEEN, AND I'VE SEEN QUITE MANY. THE INCREDIBLY NERDISH MACHO MAN JOHN RAMBO "
 DC.B "TAKES A TRIP TO AFGHANISTAN. AND HELPS THE BRAVE, PEACE LOVING REBELS TO KILL THE SADISTIC RUSSIANS. WHAT THIS FILM "
 DC.B "WANTS TO SAY IS THAT IT ONLY NEEDS ONE GOOD AMERICAN TO TAKE CARE OF 200 RUSKIES. A GREAT FILM IF YOU ARE A BIG "
 DC.B "AMERICAN PATRIOT, OTHERWISE IT'S VEERRRY BAD!   NO, GO AND SEE 'EDDIE MURPHY RAW' INSTEAD. IT'S GREAT FUN.   OR, IF "
 DC.B "LIKE HORROR MOVIES (WHO DOESN'T?) SEE 'PRINCE OF DARKNESS', THE NEWEST JOHN CARPENTER FILM. LOT'S OF NASTY EFFECTS. "
 DC.B "  IF YOU ENJOY READING BOOKS (SOME PEOPLE FIND IT DIFFICULT) THEN YOU MUST READ THE HITCH HIKER SERIES BY "
 DC.B "DOUGLAS ADAMS. I CAN WITHOUT HESITATION SAY THAT THOSE ARE THE MOST COMICAL BOOKS EVER WRITTEN. READ THEM NOW! THEN "
 DC.B "YOU WILL UNDERSTAND WHAT ALL THIS '42' AND 'DONT PANIC' THAT EVERYBODY IS TALKING ABOUT MEANS.      WELL,    I'LL "
 DC.B "TAKE A BREAK NOW. YOUR EYES ARE PROBABLY ACHING! YOU CAN REST THEM ON SOMETHING PEACEFUL FOR A WHILE, "
 DC.B "THE ZZAPGAMES LOGO FOR INSTANCE...                                    HI! TEXT WRITER STALIN IS NOW BACK ON "
 DC.B "KEYBOARD. (OH NO! NOT ALREADY!)   LET US TALK SOME ABOUT THE ST GAMES. THERES NO DOUBT THAT THESE ARE GETTING BETTER "
 DC.B "AND BETTER ALL THE TIME. AT THE MOMENT I'M HOOKED ON THE GAME 'ROLLING THUNDER' BY US GOLD. DOES SOMEONE KNOW HOW "
 DC.B "TO ACTIVATE THE CHEAT MODE? I'M HAVING TROUBLE WITH THOSE AWFUL FIRE MEN ON AREA 4.  THE ENGLISH SOFTWARE COMPANIES "
 DC.B "ARE PRODUCING LOT'S OF GOOD SOFTWARE AT DECENT PRICES. THE PRICES IN SWEDEN ARE HOWEVER ABOUT TWICE THE UK PRICE. "
 DC.B "NO WONDER THAT PROGRAM PIRACY IS SO WIDESPREAD. WHO WANTS TO PAY 30-40 FOR A GAME? ESPECIALLY SINCE MOST GAMES "
 DC.B "ARE BAD. (INDIANA JONES, NEED I SAY MORE?)   THAT IS A COMMON PROBLEM WITH ST/AMIGA GAMES, THEY OFTEN HAVE BRILL GX "
 DC.B "AND SUPER SOUND, IT MIGHT EVEN BE PERFECTLY PROGRAMMED, BUT THE GAME PLAY IS NONEXISTANT. AT FIRST YOU GET AMAZED "
 DC.B "BY THE VISUAL AND AUDIAL EFFECTS, BUT AFTER A WEEK YOU PUT IT AT THE BOTTOM OF THE DRAWER AND FORGET IT. A PERFECT "
 DC.B "EXCAMPLE OF THIS SYNDROME IS THE CINEMAWARE SERIES. YOU PAY LOT'S OF MONEY FOR A NICE PACKAGE AND A COLOR BOOKLET, "
 DC.B "BUT THE ACTUAL GAME STINKS. 40 QUID POORER FOR SOME FANCY GRAPHICS. NO, TAKE MY ADVICE. IF IT'S GOOD GRAFIX&SOUND "
 DC.B "YOUR'E LOOKING FOR, START COLLECTING PUBLIC DOMAIN DEMOS, LIKE THIS ONE. IT'LL COST YOU NOTHING, SO YOU REALLY CAN'T "
 DC.B "LOSE. I CAN ASSURE THAT YOU WILL DEFINETELY HAVE MORE FUN WITH, FOR INSTANCE, TEX'S BIG DEMO THAN ALL "
 DC.B "CINEMAWARE PRODUCTS TOGETHER. SOMETIMES THE ONLY DIFFERENCE BETWEEN DEMOS AND GAMES IS THAT THE GAME COSTS LOTS OF "
 DC.B "MONEY, GELD, PENGAR. BUT, AS I SAID BEFORE, THERE ARE LOTS OF GAMES THAT'S WORTH THE MONEY. XENON, SUPERSPRINT, "
 DC.B "STARWARS, CARRIER COMMAND, WIZBALL, BARBARIAN, BUBBLE BOBBLE. THESE GAMES ARE ALL GREAT BECAUSE THEY HAVE LOTS OF "
 DC.B "GAMEPLAY AND FEELING IN THEM. SOME SOFTWARE COMPANIES CAN'T SEEM TO UNDERSTAND THAT THIS IS THE MOST IMPORTANT BIT. "
 DC.B "INSTEAD, THEY MAKE LICENCE DEALS ON FILMS ETC. SO THAT THEY CAN SELL LOTS OF COPIES OF THE MOST CRAPPY GAME. "
 DC.B "(FRIDAY THE 13TH) PEOPLE BUY THIS STUFF WITHOUT READING REVIEWS AND BECOME VERY DISAPPOINTED. STOP BUYING THAT CRAP! "
 DC.B "MAKE THE SOFTWARE WORLD BETTER!      OK,      CHANGE OF SUBJECT AGAIN...       LET'S TALK ABOUT...           MUSIC! "
 DC.B "IF YOU LIKE INDUSTRIAL RAW SYNTH (TOO FEW PEOPLE DO) HERE ARE SOME QUICK TIPS: SKINNY PUPPY-MIND TPI, A'GRUMH...-"
 DC.B "BLOODY SIDE (THE CD), FRONT LINE ASSEMBLY-DISORDER, FRONT 242-THE OFFICIAL VERSION. BUT IF YOU REALLY ARE A SYNTH FAN "
 DC.B "YOU WILL ALREADY OWN THOSE RECORDS. ONE OF THE BEST THINGS ATARI DID TO THE ST WERE THE MIDI PORTS. TODAY EVERY MUSIC "
 DC.B "STUDIO OWNS A ATARI ST WITH STEINBERG OR C-LAB SOFTWARE. I OWN A ROLAND MT-32 SYNTH MODUL SINCE ABOUT A MONTH NOW, AND "
 DC.B "I CAN FULLY RECOMMEND THIS BRILLIANT LITTLE BLACK MUSIC MACHINE. IT'S GOT 128 PRESET SOUNDS AND 64 USER DEFINED. IT'S "
 DC.B "ALSO MULTI-TIMBRAL WHICH MEANS THAT IT CAN PLAY EIGHT SEPARATE DIFFERENT SOUND AT THE SAME TIME PLUS ONE RHYTN PART. "
 DC.B "YES, THAT'S RIGHT, IT'S GOT DRUMS TOO! JUST PLUG IT IN THE ST, LOAD SOME GOOD SOFTWARE AND YOU CAN MAKE YOUR OWN "
 DC.B "SONGS!           WELL, LADIES AND GENTLEMEN, WERE REACHING OUR DESTINATION IN TWO MINUTES. FASTEN SEATBELTS ETC. "
 DC.B "       CONGRATULATIONS DEMO WATCHER! YOU HAVE READ THIS TEXTLINE TO ITS END!          I BET THAT YOU CHEATED..."
 DC.B "           SOON WILL MY SELFMODYFING SCROLL TEXT GENERATOR MEET AN  '$FF'  AND THE SCROLL WILL RESTART. "
 DC.B "STALIN WISHES YOU DEMO WATCHER ALL THE BEST AND THAT YOU WILL SPREAD THIS DEMO... YOU WILL PROBABLY HAVE TO WAIT A "
 DC.B "LONG TIME FOR A NEW ZZAPDEMO NOW, BUT DON'T BE SORRY. WE'LL BE BACK.    BYE NOW...                      "
 DC.B "P.S. THE FOLLOWING PROGRAMS WERE USED IN THE DEVELOPMENT OF THIS DEMO: ASSEMPRO ASSEMBLER, ARTSTUDIO SPRITE DESIGNER, "
 DC.B "MICHTRONS DISK EDITOR AND RAID DEBUGGER. A BIG  'THANK YOU'  TO THE AUTORS OF THESE FABULOUS PROGRAMS. EVEN IF THEY "
 DC.B "ASK TO MUCH MONEY FOR THEIR SOFTWARE!                    "
 DC.B $FF
 ALIGN.W
L=SCR+(50*160)+80+4
M=L+(36*160)
R=160
LOGTB:
 DC.L M,M-R*4,M-R*8,M-R*12,M-R*16,M-R*20,M-R*24,M-R*28,M-R*32,M-R*36
 DC.L L,L-R*2,L-R*4,L-R*6,L-R*8,L-R*10,L-R*12,L-R*14,L-R*16,L-R*18
 DC.L L-R*19,L-R*20,L-R*21,L-R*22,L-R*23,L-R*24,L-R*25,L-R*26,L-R*27,L-R*28
 DC.L L-R*29,L-R*29,L-R*30,L-R*30,L-R*31,L-R*31,L-R*32,L-R*32,L-R*33,L-R*33
 DC.L L-R*33,L-R*34,L-R*34,L-R*34,L-R*35,L-R*35,L-R*35,L-R*36,L-R*36,L-R*36
 DS.L 50,L
LTBSL:
SWIT: DC.W $4E71
SCTB1: DS.L 10
SCTB: DS.L 10
SCTB2: DC.W 0,8,16,24,32,40,48,8,16,24
X=12288
SCTB3:
 DC.L 0,X,X*2,X*3,X*4,X*5,X*6,X*7,X*6,X*5,X*4,X*3,X*2,X
OPLT: DS.W 16
PLT: DC.W $740,$630,$666,$555,$037,$026,$666,$555,$700,$700,$700,$700,$333,$444,$555,$666
PLT1: DC.W 0,$222,$444,$555,$420,$040,$050,$030,0,0,0,0,$222,$333,$444,$555
SSP: DC.L 0
LINE: DC.W 0
STR1: DC.B $1A,$12
STR2: DC.B $08,0
ADDER: DC.W 0
SYNC: DC.W 0
SPAR1: DC.L 0
SPAR2: DC.L 0
SPAR3: DC.L 0
SPAR4: DC.L 0
NOWP: DC.B 10
MUFG: DC.B -1
FG1: DC.B 0,0,0,0,0,0
KEYF: DC.B -1,0
C3C: DC.W $050,$070,$070,$050
C3C1: DC.W $505,$707,$707,$505
C3C2: DC.W $055,$077,$077,$055
C3C3: DC.W $550,$770,$770,$550
COLTAB1:
 DS.W 20
 DC.W $004,$004,$004,$004,$004,$005,$006,$007,$007,$006,$005,$004,$004,$004,$004,$004
 DC.W $004,$004,$004,$004,$004,$005,$006,$007,$007,$006,$005,$004,$004,$004,$004,$004
 DC.W $004,$004,$004,$004,$004,$005,$006,$007,$007,$006,$005,$004,$004,$004,$004,$004
 DC.W $004,$004,$004,$004,$004,$005,$006,$007,$007,$006,$005,$004,$004,$004,$004,$004
 DS.W 42
 DC.W $000,$111,$222,$333,$444,$555,$666,$777,$777,$666,$555,$444,$333,$222,$111,0
 DC.W $000,$011,$022,$033,$044,$055,$066,$077,$077,$066,$055,$044,$033,$022,$011,0
 DC.W $000,$010,$020,$030,$040,$050,$060,$070,$070,$060,$050,$040,$030,$020,$010,0
 DC.W $000,$101,$202,$303,$404,$505,$606,$707,$707,$606,$505,$404,$303,$202,$101,0
COLTAB:
 DS.W T,$740
 DS.W 3,$740
 DS.W 3,$666
 DC.W $555
 DS.W 2,$740
 DS.W 3,$630
 DS.W 10,$740
 DS.W 3,$666
 DC.W $555
 DS.W 2,$740
 DS.W 3,$630
 DC.W $740

 DS.W 7*32
SVBL: DC.L 0
 ALIGN.W
STRI2:
 DC.B $F0,$41,16,$16,$12,$20,0,0, '     ZZAP GAMES     ' ,0,$F7,0,0
 ALIGN.W
COME:
 DC.W 0
OLPAL: DS.W 16
TAB2:
 DC.W $444,$444,$011,$022,$033,$044,$055,$066,$077,$077,$066,$055,$044
 DC.W $033,$022,$011
 DS.W 35,$444
TXSTART:
 DC.B 'ZZAPGAMES PRESENTS DEMO3 VERSION 1.0  JULY 28TH 1988............'
 DC.B $FF
 ALIGN.W
NOWPL: IBYTES NOWPL.DAT
LOGO1: IBYTES LOGOZZ.DAT
LOGO: IBYTES LOGO3.DAT
PATT: IBYTES PATTERN.DAT
JET: IBYTES JETETC.DAT
TXAD: DS.B 400
SFONT:
 IBYTES A:SMALLFNT.DAT
 ALIGN.W
FONT:
 IBYTES FONT1.DAT
BUFF:
 END


 